using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program plik");
      return;
    }
    String plik = args[0];

    StreamReader sr;
    try
    {
      sr = new StreamReader(plik);
    }
    catch(Exception)
    {
      Console.WriteLine("Otwarcie pliku {0} nie powiodło się.", plik);
      return;
    }

    string line;
    try
    {
      while ((line = sr.ReadLine()) != null)
      {
        Console.WriteLine(line);
      }
      sr.Close();
    }
    catch(Exception)
    {
      Console.WriteLine("Wystąpił błąd podczas odczytu z pliku {0}.", plik);
      return;
    }
  }
}
